(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16855,        351]*)
(*NotebookOutlinePosition[     33925,        971]*)
(*  CellTagsIndexPosition[     33841,        965]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Welcome to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox["\[RegisteredTrademark]",
    FontSize->12,
    FontWeight->"Plain"]
}], "Title",
  CellMargins->{{30, Inherited}, {Inherited, Inherited}}],

Cell["Trial Version", "Subsection",
  CellMargins->{{30, 114}, {40, 0}},
  TextAlignment->Left,
  TextJustification->0,
  FontSize->24,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[TextData[{
  "This Trial Version is a full function ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, licensed to run for a limited time, and with saving and copying \
disabled.\n\nTo obtain a permanent license for ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " with saving enabled, simply contact ",
  ButtonBox["Wolfram Research",
    ButtonData:>"ContactInformation",
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  " or an authorized ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reseller.\n\nThis document is an example of a notebook. Choose the Help \
menu to see other examples."
}], "Subtitle",
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{30, 33}, {Inherited, Inherited}}],

Cell[CellGroupData[{

Cell["How to Get a Permanent License", "Subsection",
  CellMargins->{{30, Inherited}, {Inherited, Inherited}},
  CellFrameMargins->{{4, 4}, {8, 8}}],

Cell[TextData[{
  "To get a full license for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contact Wolfram Research at any of the following addresses:"
}], "Subsubsection",
  CellDingbat->None,
  CellMargins->{{89, Inherited}, {Inherited, Inherited}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[TextData[{
  StyleBox["Wolfram Research, Inc.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "  \n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  StyleBox["phone: ",
    FontSlant->"Italic"],
  "217-398-5151\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " 217-398-1108\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 100 Trade Center Drive\nChampaign, IL 61820-7237, USA\n\n",
  StyleBox["Wolfram Research Europe Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.co.uk",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  "  ",
  ButtonBox["http://www.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://www.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +44-(0)1993-883400 \n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +44-(0)1993-883800\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 10 Blenheim Office Park, Lower Road \nLong Hanborough, Oxfordshire OX8 \
8LN, UK\n\n",
  StyleBox["Wolfram Research Asia Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  " ",
  ButtonBox[" info@wolfram.co.jp",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox[" http://www.wolfram.co.jp",
    ButtonData:>{
      URL[ "http://www.wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0506\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0509\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " Izumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101, JAPAN\n\n"
}], "SmallText",
  CellMargins->{{89, Inherited}, {Inherited, Inherited}},
  FontSize->10,
  CellTags->"ContactInformation"]
}, Open  ]]
}, Open  ]],

Cell[" ", "SmallText",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {30, 50}}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000=0P10`4000010?ooooooc?ooVOooI_oo
<ooo0?o<ooo<c?o<VOo<I_o<<oo<0?nIoonIc?nIVOnII_nI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oolcc?lcVOlcI_lc<olc0?l0ool0c?l0VOl0I_l0<ol00<coolcoc<coVLcoI/co<lco0<c<olc<c<c<
VLc<I/c<<lc<0<bIolbIc<bIVLbII/bI<lbI0<aVolaVc<aVVLaVI/aV<laV0<`col`cc<`cVL`cI/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`009WooiWoc9WoVIWoIYWo<iWo09W<oiW<c9W<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIYVI<iVI09UVoiUVc9UVVIUVIYUV<iUV09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c9T0
VIT0IYT0<iT006KoofKoc6KoVFKoIVKo<fKo06K<ofK<c6K<VFK<IVK<<fK<06JIofJIc6JIVFJIIVJI
<fJI06IVofIVc6IVVFIVIVIV<fIV06HcofHcc6HcVFHcIVHc<fHc06H0ofH0c6H0VFH0IVH0<fH003?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c3?<VC?<IS?<<c?<03>Ioc>Ic3>IVC>IIS>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V03<coc<cc3<cVC<cIS<c<c<c03<0oc<0c3<0VC<0IS<0<c<0003oo`3oc03oV@3oIP3o
<`3o003<o`3<c03<V@3<IP3<<`3<002Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc01VV@1VIP1V<`1V000c
o`0cc00cV@0cIP0c<`0c0000o`00c000V@00IP00<nh00=d00;/00:X008P007L005D004@002800140
003^003M002k002Z0028001g001E0014000R000A0000kP00g@00^`00ZP00R000M`00E@00A0008P00
4Nk^k]gMgK^k^jZZZXR8R7MgMeEEEDA4A28R8Q4A4@0000@000CeHV7e1@000e]RH@09000<mF9QHHIW
HF:5HV7e2P002ODaHXERHHIQ1P0<000;HF:5HV66HF:5H@L020000f:53@0<0003Ff5K00P000<6QV40
1P000f5RF`0>000::f5QHV66HF9K:P/000<aHC402@000oERQ@05000010000oEQQP050004:V:5m@T0
00ceHF:6HF:6HF:5H_D:000:FhIQHSMKHXERmP/000QRQF9WQV5RR`9R00<Z00001P0015]RFoD:0004
1V:6mPP000CfHHGe1000131RQOD<000595aQQF800U/01S5QHXERF`X000=KHUD02@001?IQH_D40000
100010J6HOD30004mF9Q<@X000?eQF4010000oD0000;0004Ff5R:P@000@aQF7e2P000hIQm@0@0004
mF661PX000=EHF402@000bYRHP0400041V:51``000D`HV5RmP060003<F5R00X000<aRc402@001?F6
HOD4000010001?ERHOD30003HXEQ00/000?eHF804@0010J6HRX60003=hHa00T000?eHF804P000e]R
F`0:0003HV4a00T000?fHVL010000f:5<@0<0004<69RF`X000=K000020000e]R<@090004mF5Qm@@0
00040003mHEX008000Ge<F5Rm@0;0003mF:5014000?fHF801`000oEWHP0:0003HXD0014000CeIf;e
20000c65HP0:0003mV6600<000AKHV7e30000f:5=`0F0003<HDa00T000@6QV;e100000@000WfHV7e
00J6HC4030000oEQHP0C0003m@0000H000>6H@002@000hIQm@0B000>G8Dg:c4Z:c4[<2]QHS490004
m@J6H@8000@[HHD[30000c66H@0G0003Ff8a00T000<THVL01@0000@000?eHHH00P000f5RE@0=0003
mF9Q01/000?fHHH02P000fMR000B000>:V:5HV5RHF9QHV5RQOD:0003mV5R00;e00=QHS403@02H@03
:`0001D000<gQC402@001?F5H_D4000010001`J6H@1KHV403P000oF5H@0K0003HF8a00X000>6H@00
4`00365RFoHa:bXa:f66=`/000L6HXD0Ff9K00d000?fHF8060000eER<@090004mF9Qm@@000040007
mF5REF:5mP0>0003mF9Q01T000GfHF:5m@0:0003HHH001<000<[HF401@0010J6HOD;0007mH]RFf66
1P0=00031XIK01P000<gQC402@001?IRQOD4000010002OERQFQQHV5R<@0<000;mF66:PLZ<BX7<?H0
3`001S5KHXEQm@X000_eHV7g<0LZm`Ha:P0=0003HF;e00@000=EHU/030002BYRHF9XHF:5<@0;0003
:f4a01P0011EHV7f<BXamS3f<BXaHF86100000@000XTHV4[:S5KHHIQ30002VQQHXERHHIQQV4=0006
<F:5If8a3@002hERHF:5HV66HF;e00`000<[Ie/01002H@03mP0000X000X7QF8ZmS5KHV5K2P000bYR
F`0H000?=f66HHERHHIRQF66HHER00D0000400041V:5m@<000CfHF;f2P001_F5HUDgE@8a00=K<C40
30001F5RQF4[00l000YRQCME=eDa=eDa3P000f66mP020003mV5L00d000<ZHXD010001?EQQ_H90003
mHIQ01P000=EHU/01C40230a<C4gHXGe100000@000?eHF801@000c5QF`0;0003HV40018000AKHF8a
4@000f5R000E0003<F4a008000=KHS003@000oEQHP050003<F4a00X000=QH_D05`000cN5<@090004
mF5Rm@@000040003mF9Q00D000?eQF802P000oEQHP0B0003mV6601<000=RQ@005@001oEWHP0ZHV40
3P000oF<H@050003mV9K00X000<aQE/05`000eEX<@0900031V6600D000040004mF66m@@000?eHV40
2P000oERH@0B0003<F9Q018000?eHFP05`001U^6<CN6<@h000@[HF;e10000oEQHP0:0004mV9QmQH0
00<gQC402@0012ARHOD4000010001?ERHOD40003:VQK00X000?eQF804P000oJ;HP070003m@0000T0
00>5HP005P000oIQQP02H@03m@0000`000<6QV401@000c65F`0;0004Ff9QmPX000<[000020000eER
<@090004mHaQm@@0000400041hEQ1P@000=RQC402P001?ERHOD40003m@0000X000DZHV8Zm@040003
HC4000X000=RHOD00`000oD0000A0004HF9QHPl000CfHF;e0`0010IRHOH<0005HHIR<?D01`000c5Q
00090003=f5E00T000CeHF;e100000@000/THXHZmS4gQV5Rm@0:0004mF:5mP8Z0_H2:P03mP0000T0
00YKHF8Zm@06FhIQ2P000oF5HP02:P;f0RX00oHZm@0?0004<F66:Pl000[fHHGf:S4gQV5R3P001U]Q
QSL[1P8000Ge<E^;HP0:0003EFPa00T000CeQV7e100000@000<6HV400V801F66HF7e00/000CeHF9Q
0f801F5RHV;e00/000URHHIQHXERHOH02`000f9QHP02HP03HF9R009R00<600003P000hIQ000?000:
:V9RHF9QQV5Km@l000`aHXERHF:5HV5XH_H:0003=hDa00T000CeHF;e100000@000GeFf5KH@02<@03
mP0000/000GeHE]KH@02F`04HE]KH@d000HaHHIQHU/=0005Ff5KFf400U/0165KFoH@008a40001OEQ
FeaQ008a00?f00004@002C5QQV5RQF8Zm@0;0003<E/a00T000?eFf401@0003@000?e0000:002mBh0
0_DS0000]0000;@000001?Ohn?L3n005moShn?L00oP01OOhn?Sg00?h00?gn?L00oP01OOhn?Sg00?h
00Ggn?Shm`03n003moSh00Gh00Ggn?Shm`02n004moShm`;h00?gn?P00oP01OOhn?Sg00?h00Ggn?Sh
m`03n005moShn?L01?P01OOhn?Sg00Ch00Cgn?Sg0oP01OOhn?Sg00?h00Ggn?Shm`03n005moShn?L0
1_P01?Ohn?L3n005moShn?L00oP01OOhn?Sg00?h00Cgn?Sg0oP01OOhn?Sg00?h0OL1n00003_g:b_g
:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:`02m`0R
:oOgmb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[mb_g:oL[m`8[00Kg:oL[mb/2m`03:oL[00Cg01X[mb_g
:oL[mb_g:oL[mb_g:oL[mb_g:oL[m`8[01Og:b_g:oL[mb_g:oL[mb_g:oL[mb_g:`02m`0>:oL[mb_g
:oL[mb_g:oL1:`00]0000;@000090003m@3e00800_D80004m@3e00Ce4003mH400008000:<F66HF:5
HV66m@D000LaQF9QQV5R009Q00?e000020002oDaHXEXQF9QHU/a00P0013eFf9QHV5KHF9QFf9QFf9Q
0P000c5RF`02H@04HU]K<@P000WfHF5QG65KHC400`00235QHF5KHV5K0V401V9KHEaQHP9Q00<Z0000
100010MQHE`3H@07HV4Z<EaQHP02F`9Q00?f00000P001U]RFf5R1P@00f401F9QFf5R00D00008000:
<F9QHXEXQF9Q<@D000IRHF:5J8D2HP03Q@L000L0013eFf66HF9QHXERHF9QQS3e1@004?IQQF9QHXER
HF:5HF:5HF820009Ff5RHHIQJ8Da00P000TZHV5RRf9QHS400P001`J5HV9QHXD00V802hGfHFQQQF9Q
HXD700H001<aQF9QQV5RHHH0<F66HFR6HHH<00<000L6QV5QHV4[00<000WeHXERHHIQHV401@0000P0
00YEHF:5HV5RHF9K10002oF5HXERHF:5HF8`00L0018aHV66HF9QQV5RRf9QQV5RHOD40007mV5RHF:5
HP02H@07QV66HFQRQ@020009Ff:6HF:5HV4a00P000T[HF:5HV5RRc400P0055ERHF66HF:5IoH0HF:5
HV66HF9K1P004e]RHHIQHXER<@0ZHV5RQF5RHOH00`001oMQHV9QQSL00`002OEQHXERHF:5F`050000
20002V5RQF5RQF9QQV440006mVMRHHIQ0V800hER<@060007EF6<HF9QQP02H@0;QV5RHHIQQV5RHOH0
0`001`J6HF:5HX/00V80165RHHH2H@0<HP00<F5WQV5RQF8a20002@N5HV5RQF9QE@020006J666HF:5
0V8045/00365HV5RHHIQHV5RHHH2H@0CQV5RHF:5HXGf00J5HXERHHIQ<@030007HHIQQV5RQ@030009
mV9QHXERHF8a00D00008000;QV5RHXERHHIQJ2X00`002e]RHHIQHV65HV5E00D001GgIf9QHXERIhIR
HF9QQV5RIf:5HV400`004?IQQV5RHF9QQF9WQV5RQV420009Ff:6HF:5HXDa00P001@ZHXERQF:5HS40
Ff:5HXERHF:5m@8000ceHV66HHIQHXERRf82H@9R00N5HVN6HF9Q00<000QRHF9QQV5XE@8000WfHF9Q
HXERHC400P002BYQQV5RHHIWmP0500001`00305WHXERHF:5HV66=`<000EQQV5RQ@02HP04HF:5HPD0
02AQQV5RHF:5HV65HV66HF:5HV5RQF9K1P3eJ666HF:5HV5RQF82H@0=HXH003N5HV5RHF9Q<@08000C
mVMRHF9QHXDa:V:5HV5RQFQQ<@04000=Ff9QJ65RQF9QHXERQP02H@07HV66HHIQ<@030008HF:5HV5R
QCL20009:V:5J65RQF9K008000PaQV66If9QQPH000070003:V66009Q00N6HFQQQV5R008000`6QV66
HF9WQF:5J644000Y=hIQHXERQF9QQV9QQVMRQF9QQV5RHHcf0?IQQV5RQF9QHXERHHERQF400P002E]R
HHIQHXER<@08000;:V9QQV5RQFPaFf800V401F:6HF9K00D001DaHF:6HHIQHV66HF9QQF9QQV5RHF80
10002365HV5RQF9K0P000f:5HP02H@0>QV5RHOD0<F5RHF9QQV4600001`002C66HFQQHXERH@02HP0@
QOD0<F5RHHIQQV5RHHIRm@<000YRHF:5HV5RHHDg0_D05P3fHF9QQV66HF9QF`3fHV5XQF9QHXD7<@80
00UKHF9QS65RQC4020003@N5HV66HF:5HF9QQVP00V400hIQm@05000EmHIQHF9QQV5RHHIQJ69QQV66
HHIQ00@001daHV66HF9QHP3eHF9QQV9QHXER:P0aQV5RQF9QHP0600001`00635QHXERQF:5HV65HS40
Ff9QS65RHF9QQP9Q00gf003eQF:5J65RQF8a00D001CeHHIQHV5RIhIQ0@J5HXERHHIQJ0T000mEHXER
HHIQHV5KHE]QFc400P004BYRQFQQQV5RHF:5HXEQQV7e00L000PgQF9QQV5RR`<a00UKHHIQJ65RHC40
10002_IQQV5XHHIQ02X2HP0ARf:5HHIQQS40Ff5RQF9QHU/01P0000L000=QHXD00V82H@0DHXERHHER
06:5HV66HHIQHV66HC420005<F9QHXH00V400f:50006000<:f5XQF:5HV661_IQ0V801F66HF:500T0
00lgHF:5HV5RQF9QQV5RHED00P004@N5HV5RHHIQQV5RHF9QJ5/a00L000T[HHIWHF:5HRX00P002C66
HHIQHXERm@04000>mHERHHIQHXH0=hEQHV42HP0=If9QH@1KHX]RHHIQ<@0600001`000hIQHP02H@0F
HXIQHF:;HV7fHF:5HV5RHF:5J666<@8000UKHF:5HHIRQCL020004f66HF9QHXER:_ERQF66HF:5H_D0
20003e]RQF9QHXERQF9QHV6<<@02000C:V9QQV65HV5XHV66HF:5HXER1P060008HV66HXERHC420006
QVMQHV660V46000LHV66HHIQI`26HHIRHHIQQF9QQP26HF9QQV5R:PH00006000LmF66HF:5HF9KHV5R
HHHgQF9QQV5KHV5RQF9QHP8000@aQV5R0V400f9Qm`08000<QV5RQF9QHV4a1XIR0V4018IQHV49000?
=hERHHIQHV5RQF9QQV4a008000CfHHIQ0V803HERHHERHHIQHV5RQF801P003e]RHF5RHHIK005QHXER
Q@02HP03E@0000@001aQHV5RHF:6<F5RHF:5=f9QQF9Q:fMRQF9QHXD11P0000H001`ZHV66HFR6HOJ5
HV66HF9QQV5RHOIQQV5RHHIQ0P002E]QIhIQHXER=`080008If:5HV66HH`2mP9Q00J6HV5XQF89000?
EF9RQF9WHXERHHIQHV5E008001@ZJ65RHH]RHHERHFQQQV66HF:5<@D0018`HXERHHIRHODZHXERHF9Q
IoD6000?Ff:5HV66HE]QHV65H_J5009R00Z5HV5RQF9QHXER1`0000H000GgHF9QQP02H@0EHP1QQV5R
QF9WHXERFoIRHHIQHV66008000TaQV9QHXERQE`01`002B]RQF9QHV5RH@02mP04HVMQQP9Q00=RQOD0
20003cN5HF9QQV5RRf9QQV5R<@0200091hERHHIRHHHa00;e00UEHV5RHHaQHU/01@004OEQHXEXHHER
93N5HXERHHIK00L000XgHF:5HV5RQF:50V801V40HXEQHP9Q00N6HF:5HVMQ00L00006000O=hERQF9Q
HU/0G666HF9QQV5RHC40Rf9QHXEXHOH0:`02H@07HXERHF:;<@05000DmF5QHV66IhIQH_DZHF:6HF:6
HF890009Ff9RHHIQHV4a00;e00<6mOD00P001ODZHXER009Q00>6HC400`0026N6HHIQHV661P0015aQ
HXD2HP0:HC5QHV5RHHIQ<@L001_fRf9QQV66HFQQQV4g035QHXEXQV5RQF9QHUD01`0000H001MQHV5R
HHIQ<@0`HV66HF9QQV660?EQQP02H@04HXER<08001]RQF5RQFQQHV5Km@3e1hERQF9QHV5RQF40mHH0
0V401F:5HXER00T000UEIhIQHXERQC400`000oD000020009mV5RQF9QHVME00<000QRHF9QQV5RH@H0
00l`QV5RQF5RFf:5HVN6HF8020004_IRQF9QHV66HF9QQRX0:V9QHP9Q00N6HF9QQV4a00L00006000A
HV66IhIQQS40mF:5J65RQF800V420008HV66HXERHC42000JFf:6HF9QQV66HF:5HXERIf9QQV65HV4[
0?H2H@06HXERHF9W2@008e]RHF:5HV5XFoHZ:`H[<040:V:5J666HHHa1_EKHF:5HV66009Q1P003oER
HHIQHX]RHF:5HV5RF`08000=mF5RQF9WQV5RQF9Qm@02000<HXERHHIQHV66If;f1`0000D000?eQF80
0V40169QHC420009Ff9QQV5RQF8a008000QRHF5RHHIQHP8001?eIf:5HF9QHV66HFQQHXERHHIQ009R
00f5HP00mHaQQV65HV6600T002DgQF9QHXERHHIQHV66HF8Z00N5HV66HF9QQV5RHHIQJ8ERHHHg00L0
00EKHV5RQP02H@07QV5RHHIQ:`09000;QV5RHHIQHV5RQF800`0035]RHHIRIf66HF:51PL000050009
:f5RHHIRQF8[008000DaHHIQQP02H@0<H_D005^5HXEXHHIQ0`005S65HV:5HV66HF9QHXERQF9QJ665
HRX20004mV5RH@9R00=WQV402@009E]RHHIQHV66HF9QQV5RHC7e:V9QQV5RHHIQHV66HHIQHV66HB/0
1`003C5QHXEQHXIQJ666HF802P002f5RHHIQHXERQF9K00<000<aHHH00V401XIRHF:5HPP000050004
<6:5HP9Q00=RQ@H00P002?ERHF9QS69Q0`002E]RHF:5HV5R9002000EmF9QHF:5HVN6HHIQHV5RQF:5
HV4a00<000CfHXER0V400hIQHP09000T<HIQHX]RHF9QQVMRHHIR:P3fIf9QHX]RHF:5HVMRHHIQHV5R
2@0038IQHXEQHV66HF:5=`X000]QHV5RQF5XHF9Q<@03000;mF9QHXEQQV5RHE/0200000@000[e<HIQ
HV6<HF;e0`001f65HXERHED00`002C5QHXERHF:51`04000BHHIQHXIQHV5RQF9QQV5RHF8a10002@J5
HV66HV5RQ@09000=Ff5RQF9QQV66HF9QQP02H@0E<@3eQV5RQF9QHXERHF:5HV66HF8Z00T000`gRf9Q
HV66HHIQH_H:0004<F66H@9R00EQQV66m@04009Q00R6HF9QHXERF`P000050009HV5RQF9QQV7e00<0
00LaHV5RHHH600<000TaJ8ERHHIQJ2X01@0043N6HF5RQF9QHV66HF:5HRX50009mF9WQV65HXER00T0
02<gQV5RHHIQHV66HHIQQV7f031RHHIQQV66HF:5HV65HV5R:P0:000;:f66HF:5HV5RQF402`002b^5
HXEQHXEQHV7e00@000XaQV66HF:5HV4a200000D000QQHXERQF9QQP@000KeHHIQQV440009mXERHHIQ
HXDa00L000aKHXERHHIQQVQQQC470003mV66009Q0V800f5X0008000MEF5XHHIQHV6<HF9QHV5R<@3f
HHIQHV5RHFR5HV400V800e/a000<000:HV5RQFQQHXEX<@/000KfHF9QJ8D2HP03HE/000@000[fHF9Q
J8ERHFPZ200000D00_D00`Kem@02m@031P0000<000?e1_D00_D500?e00<6mOD00_D90004<E]QHP9Q
00=E1`002@00234Z<B/`:c4Z2@0042XamS4Z<OHa:S4[<2/a:_D2000=<B/`:c4Z<OHa:S4Zm@0?000:
:S7f<BXamS4Zm@`000Ta:S7f<BXa:`H01P00234Z<OHa:S4[2@000001


\>"], "Graphics",
  CellFrame->{{0, 0}, {0, 3}},
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  CellFrameMargins->{{0, 0}, {100, 8}},
  ImageSize->{180, 52},
  ImageMargins->{{142, 0}, {0, 34}},
  ImageRegion->{{0, 1}, {0, 1}},
  Background->RGBColor[1, 1, 0.999985]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{473, 380},
WindowMargins->{{2, Automatic}, {Automatic, 9}},
WindowTitle->None,
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
CellMargins->{{0, 10}, {0, 20}},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
    "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    CellBracketOptions->{"Color"->RGBColor[0, 0.4, 0.300008]},
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.900008, 0.700008]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellFrame->{{0, 0}, {0, 2}},
    CellMargins->{{26, 29}, {0, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CellFrameMargins->{{4, 10}, {4, 4}},
    LineSpacing->{1, -5},
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Printout"],
    LineSpacing->{1, -5},
    FontSize->24,
    FontColor->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{90, 29}, {0, 0}},
    CellGroupingRules->{"NormalGrouping", 10},
    PageBreakBelow->False,
    CellFrameMargins->10,
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Plain",
    FontColor->GrayLevel[0],
    Background->RGBColor[1, 0.300008, 0.300008]],
  
  Cell[StyleData["Subtitle", "Printout"],
    FontSize->18,
    FontColor->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{27, Inherited}, {6, 0}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellFrame->{{5, 0}, {0, 2}},
    CellDingbat->None,
    CellMargins->{{30, 20}, {10, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->{{10, 4}, {6, 6}},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontTracking->"Plain",
    FontColor->GrayLevel[1]],
  
  Cell[StyleData["Section", "Printout"],
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    CellMargins->{{48, Inherited}, {Inherited, 18}},
    CellGroupingRules->{"NormalGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Printout"],
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[GrayCircle]",
    CellMargins->{{49, Inherited}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Printout"],
    FontSize->10]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{90, 29}, {Inherited, Inherited}},
    CellFrameMargins->4,
    LineSpacing->{1, 0},
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Printout"],
    LineSpacing->{2, 0},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    FontSize->9]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellFrame->{{1, 1}, {0, 1}},
    CellMargins->{{45, Inherited}, {0, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontSize->16,
    FontWeight->"Bold",
    Background->RGBColor[0.990173, 0.734493, 0.951598]],
  
  Cell[StyleData["Input", "Printout"],
    FontSize->14,
    Background->GrayLevel[0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellFrame->{{1, 1}, {1, 0}},
    CellMargins->{{45, Inherited}, {Inherited, 0}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    Background->RGBColor[0.969436, 0.727916, 0.508858]],
  
  Cell[StyleData["Output", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellDingbat->"\[LongDash]",
    CellMargins->{{70, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontSize->12,
    FontSlant->"Oblique",
    FontColor->GrayLevel[1]],
  
  Cell[StyleData["Message", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, 20}, {3, 3}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    TextAlignment->Left,
    FormatType->InputForm,
    StyleMenuListing->None,
    Background->RGBColor[0.654582, 0.773571, 0.852674]],
  
  Cell[StyleData["Print", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellFrame->{{1, 1}, {0, 0}},
    CellMargins->{{45, Inherited}, {0, 0}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    ImageMargins->{{35, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    Background->RGBColor[0.965682, 0.919066, 0.758984]],
  
  Cell[StyleData["Graphics", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Automatic Numbering", "Section"],
  
  Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{72, 72}, {Inherited, Inherited}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False,
    FontFamily->"Times"],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{72, 72}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedFigure"],
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Figure ", 
              CounterBox[ "NumberedFigure"]}]], None}},
    CounterIncrements->"NumberedFigure",
    FormatTypeAutoConvert->False,
    FontFamily->"Times"],
  
  Cell[StyleData["NumberedFigure", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedTable"],
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    CellFrameLabels->{{None, None}, {Cell[ 
            TextData[ {"Table ", 
              CounterBox[ "NumberedTable"]}]], None}},
    CounterIncrements->"NumberedTable",
    FormatTypeAutoConvert->False,
    FontFamily->"Times"],
  
  Cell[StyleData["NumberedTable", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["LeftHeader"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["Footer"],
    TextAlignment->Center,
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["LeftFooter"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell["\<\
The \"RefGuide\" style is for linking automatically to the \
on-line Reference Guide help system.\
\>", "Text"],
  
  Cell[StyleData["RefGuide"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{1, -5},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None]
  }, Closed]]
  }, Open  ]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ContactInformation"->{
    Cell[3424, 110, 2308, 87, 358, "SmallText",
      CellTags->"ContactInformation"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ContactInformation", 33728, 958}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 235, 8, 80, "Title"],
Cell[1969, 61, 181, 6, 67, "Subsection"],
Cell[2153, 69, 739, 20, 183, "Subtitle"],

Cell[CellGroupData[{
Cell[2917, 93, 148, 2, 37, "Subsection"],
Cell[3068, 97, 353, 11, 44, "Subsubsection"],
Cell[3424, 110, 2308, 87, 358, "SmallText",
  CellTags->"ContactInformation"]
}, Open  ]]
}, Open  ]],
Cell[5759, 201, 83, 2, 92, "SmallText"],
Cell[5845, 205, 11006, 144, 197, 10720, 135, "GraphicsData", 
"Bitmap", "Graphics"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

